/************************************************************************************************
 * Twilight : twilight calculation program : the passive igloo project : main class
 * Twilight 2016 is Copyright (c) 2016, Peter Gallinelli
 *
 * created : February 2016 by peter gallinelli
 * history :
 * version 0.3
 * - added moon calculations and display : pg 2016-05
 * - added calendar (leap years) : pg 2016-05
 * - added dynamic resize functionality : pg 2016-05
 ************************************************************************************************/

/* TODO:
 * fond toil (?)
 * 
 * BUGS:
 * prise en compte levation de l'observateur pour hauteur horizon et lever du soleil ...
 * validation obstructions
 */


import java.awt.*;
import java.awt.event.*;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

import java.text.Collator;
import java.text.DateFormat;

import java.util.Date;
import java.util.Locale;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

class twilight extends JFrame {

    // beginning of INIT section
    // =========================

    String appName = "Twilight";
    String appVersion = "beta 3";
    String[] maxime = {
        "  the passive igloo project - http://igloo.sailworks.net  ",
        "      99% of all energy on earth comes from the sun       ",
        "everything in life is only as difficult as you think it is",
        "                        enjoy :-)                         "
    };
    boolean english = true; // application language

    // station data
    // -------------
    File fileDirectory = null;

    String stationFn = "-"; // default station fileName
    String stationName = "Default station"; // default station name
    String stationState = "-";
    String stationCountry = "-";
    String stationLat = "45"; // default station latitude
    String stationLon = "0"; // default station longitude
    String stationAlt = "0"; // default station altitude
    String stationYear = "2000"; // default year
    String stationMonth = "1";
    String stationDay = "1";
    String stationZone = "1"; // station time zone (neg = West)
    String stationDls = "0"; // daylight saving 0 = no; 1 = yes
    String stationPaz = "180"; // default surface orientation (south)
    String stationInc = "0"; // default surface angle (horizontal)
    String stationAlbedo = "0.15"; // default ground albedo

    boolean refractionOn = true; // calculate solar refraction?

    double stationLatVal = Double.parseDouble(stationLat);
    double stationLonVal = Double.parseDouble(stationLon);
    double stationAltVal = Double.parseDouble(stationAlt);
    double stationYearVal = Double.parseDouble(stationYear);
    double stationMonthVal = 0;
    double stationDayVal = 0;
    double stationZoneVal = Double.parseDouble(stationZone);
    double stationDlsVal = Double.parseDouble(stationDls);
    double stationPazVal = Double.parseDouble(stationPaz);
    double stationIncVal = Double.parseDouble(stationInc);
    double stationAlbedoVal = Double.parseDouble(stationAlbedo);

    // application layout
    // ------------------
    // these are updated on window resize -> myDisplay
    // default WINDOW dimensions [px]
    int inTop = 0; // inset values for Frame
    int inLeft = 0; // inset values for Frame
    int imgX = 920 + 8; //3 * 365 + 2; //920; // width
    int imgY = 530; // heigth

    // default GRAPH dimensions [px]
    int x1T = 0; // position x
    int y1T = 0; // position y
    int x2T = imgX - 10; //918; // width
    int y2T = (int) (imgY * 0.65); //350; // heigth

    // default BANNER dimensions [px]
    int x1Z = x1T; //0; // position x
    int y1Z = y2T + (int) (0.04 * imgY); //370; // position y
    int x2Z = x2T; //918; // width
    int y2Z = (int) (imgY * 0.14); //75; // heigth

    // zoom interval : expressed in hour of year (hoy)
    double hStart = 40 * 24; // default value : day 20
    double hEnd = 54 * 24; // default value : day 54

    Font tableFont = new Font("lucida console", Font.PLAIN, 11); // default font for drawing (Font.BOLD)
    Color tableColor = Color.white; // default color for text display


    // color palettes definition
    // -------------------------
    // NOTE: tempSet defines the upper limit of a colour in the list !
    int palette = 0; // default palette
    int colorSetSize = 20; // size of the colorSet
    Color[][] colorSet = { // colour sets
        { Color.black, Color.black, new Color(80, 0, 120), new Color(0, 0, 200), new Color(0, 160, 255),
          new Color(128, 255, 255), Color.orange, Color.yellow, Color.white, Color.white },
        { Color.black, new Color(80, 0, 120), new Color(0, 0, 200), new Color(0, 160, 255), new Color(128, 255, 255),
          Color.orange, Color.yellow, Color.white, Color.white },
        { new Color(0, 0, 0), new Color(80, 0, 100), new Color(100, 0, 160), new Color(60, 0, 200),
          new Color(30, 70, 220), new Color(0, 100, 230), new Color(0, 130, 255), new Color(50, 180, 255),
          new Color(140, 200, 255), new Color(230, 245, 255), new Color(200, 0, 0), new Color(220, 0, 0),
          new Color(255, 0, 0), new Color(255, 100, 0), new Color(255, 195, 0), new Color(255, 255, 0),
          new Color(255, 255, 100), new Color(255, 255, 128), new Color(255, 255, 190), new Color(255, 255, 255) },
        { new Color(0, 0, 0), new Color(80, 0, 100), new Color(100, 0, 160), new Color(60, 0, 200),
          new Color(30, 70, 220), new Color(0, 100, 230), new Color(0, 130, 255), new Color(50, 180, 255),
          new Color(140, 200, 255), new Color(230, 245, 255), new Color(200, 0, 0), new Color(220, 0, 0),
          new Color(255, 0, 0), new Color(255, 100, 0), new Color(255, 195, 0), new Color(255, 255, 0),
          new Color(255, 255, 100), new Color(255, 255, 128), new Color(255, 255, 190), new Color(255, 255, 255) },
        { new Color(0, 0, 0), new Color(80, 0, 100), new Color(100, 0, 160), new Color(60, 0, 200),
          new Color(30, 70, 220), new Color(0, 100, 230), new Color(0, 130, 255), new Color(50, 180, 255),
          new Color(140, 200, 255), new Color(230, 245, 255), new Color(200, 0, 0), new Color(220, 0, 0),
          new Color(255, 0, 0), new Color(255, 100, 0), new Color(255, 195, 0), new Color(255, 255, 0),
          new Color(255, 255, 100), new Color(255, 255, 128), new Color(255, 255, 190), new Color(255, 255, 255) },
        { new Color(0, 0, 0), new Color(80, 0, 100), new Color(100, 0, 160), new Color(60, 0, 200),
          new Color(30, 70, 220), new Color(0, 100, 230), new Color(0, 130, 255), new Color(50, 180, 255),
          new Color(140, 200, 255), new Color(230, 245, 255), new Color(200, 0, 0), new Color(220, 0, 0),
          new Color(255, 0, 0), new Color(255, 100, 0), new Color(255, 195, 0), new Color(255, 255, 0),
          new Color(255, 255, 100), new Color(255, 255, 128), new Color(255, 255, 190), new Color(255, 255, 255) },
        { Color.black, new Color(100, 0, 100), new Color(0, 0, 100), new Color(0, 0, 255), new Color(255, 255, 0),
          new Color(255, 128, 0), new Color(255, 0, 0), new Color(180, 0, 0), new Color(100, 0, 0) },
        { Color.black, new Color(100, 0, 100), new Color(0, 0, 100), new Color(0, 0, 255), new Color(255, 255, 0),
          new Color(255, 128, 0), new Color(255, 0, 0), new Color(180, 0, 0), new Color(100, 0, 0) }
    };
    double[][] tempSet = { // color offset list
        { -90, -20, -14, -8, -4, -0.2, 0, 12, 55, 90 }, // twilight default
        { -90, -18, -12, -6, -1, -0.2, 12, 60, 90 }, // default discrete
        { -90, -80, -70, -60, -50, -40, -30, -20, -10, -0.8, 0, 10, 20, 30, 40, 50, 60, 70, 80, 90 }, // sun altitude
        { -90, -80, -70, -60, -50, -40, -30, -20, -10, -0.8, 0, 10, 20, 30, 40, 50, 60, 70, 80, 90 }, // altitude discrete
        { -90, -80, -70, -60, -50, -40, -30, -20, -10, -0.8, 0, 10, 20, 30, 40, 50, 60, 70, 80, 90 }, // moon altitude
        { -90, -80, -70, -60, -50, -40, -30, -20, -10, -0.8, 0, 10, 20, 30, 40, 50, 60, 70, 80, 90 }, // altitude discrete
        { 0, 10, 150, 350, 500, 650, 800, 1000, 1500 }, // energy
        { 0, 10, 150, 350, 500, 650, 800, 1000, 1500 }, // energy dicrete

    };
    boolean[] palDiscrete = { false, true, false, true, false, true, false, true }; // discrete or interpolated colours

    // Palette for moonshine overlay (adjusted to twilight palette)
    Color[] colorMoon = { Color.black, Color.black, new Color(80, 0, 120), new Color(0, 0, 200), new Color(0, 0, 200) };
    double[] setMoon = { 0.0, 0.18, 0.65, 0.8, 1.0 }; // offsets
    
    // horizon data
    // ------------
    boolean obstruct = false; // draw and calculate with obstructions?
    double[][] horizonFileDummy = { { 30, 180, 330 }, { 0, 0, 0 }, { 1, 1, 1 }, { 3, 3, 0 } };
    double[][] horizonData = calcHorizonAngleTable(horizonFileDummy, 0); // load horizon data into table
    // az angle [0][i] / altitude angle [1][i]

    // general variables
    // -----------------
    double yearDays = 365;
    int[] JM = new int[14]; // cumulated days of month [d]
    String nomMois[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
    int displayMode = 0; // menu radiobutton selection
    boolean bannerOnly = false; // display all = false; display banner only = true

    // interface
    // ---------
    Container container = getContentPane();
    private JPanel jPa_0 = new JPanel();
    private JLabel jLa_T = new JLabel();
    private JLabel jLa_H = new JLabel();
    private JLabel jLa_S = new JLabel();

    myDisplay display = new myDisplay(); // the canvas

    // mouse move control
    private int xStart = 0;
    private int yStart = 0;
    private int xAct = 0;
    private int yAct = 0;
    private int xdiff = 0;
    private int ydiff = 0;

    String lT = "'clic' on graph or";
    String lH = "'drag' to zoom";
    String lS = "> ready";
    
    // classes
    // -------
    transient sunCalc suncalc = new sunCalc();
    transient moonCalc mooncalc = new moonCalc();

    // ===================
    // end of INIT section


    /**
     * ================================
     * Constructor :  build application
     * ================================
     */
    public twilight() {

        // constructor for labels        
        jPa_0.setLayout(null);
        jPa_0.setBounds(imgX - 160, y2T - 60, 120, 35);
        jPa_0.setBackground(Color.black); // (new Color(80, 80, 80));
        jPa_0.setBorder(BorderFactory.createLineBorder(Color.gray));

        jLa_T.setBounds(new Rectangle(5, 2, 110, 10));
        jLa_T.setFont(new Font("dialog", Font.BOLD, 10));
        jLa_T.setForeground(Color.white); // new java.awt.Color(0, 255, 0)
        jLa_T.setText(lT);

        jLa_H.setBounds(new Rectangle(5, 12, 110, 10));
        jLa_H.setFont(new Font("dialog", Font.BOLD, 10));
        jLa_H.setForeground(Color.white);
        jLa_H.setText(lH);

        jLa_S.setBounds(new Rectangle(5, 22, 110, 10));
        jLa_S.setFont(new Font("dialog", Font.BOLD, 10));
        jLa_S.setForeground(Color.white);
        jLa_S.setText(lS);

        jPa_0.add(jLa_T, null);
        jPa_0.add(jLa_H, null);
        jPa_0.add(jLa_S, null);
        container.add(jPa_0, null);

        // init application
        getThisYear(); // init date

        //twilight.this.setSize(2 * inLeft + imgX + 1, inTop + imgY + 7); // size the frame
        twilight.this.setSize(2 * inLeft + imgX + 16, inTop + imgY + 61); // size the frame
        twilight.this.setTitle(appName); // set app title
        twilight.this.setIconImage(new ImageIcon(getClass().getResource("icon.png")).getImage()); // set app icon
        twilight.this.setResizable(true); // set app behaviour
        
        display.setBackground(new Color(100, 100, 100)); // set app bg color
        twilight.this.add(display); // add the graphics
        twilight.this.setJMenuBar(new myMenu()); // add the menubar
        twilight.this.setVisible(true); // let the composite of the frame, canvas, etc. become visible

        // perform keyboard action
        twilight.this.addKeyListener(new KeyAdapter() {
            public void keyPressed(KeyEvent k) {
                int kk = k.getKeyCode();
                System.out.println(kk);
                
                // go back one selection period : (<-) key
                if (kk == 37) {
                    if (!bannerOnly) {
                        if (hStart - (hEnd - hStart) > 24) {
                            double tmp = hStart;
                            hStart = hStart - (hEnd - hStart);
                            hEnd = tmp;
                            display.repaint();
                            //display.repaint(x1Z, y1Z, x2Z, y2Z);
                        } else {
                            hEnd = (hEnd - hStart);
                            hStart = 24;
                            display.repaint();
                            //display.repaint(x1Z, y1Z, x2Z, y2Z);
                        }
                    } else {
                        if (hStart > 24) {
                            hStart = hStart - 24;
                            hEnd = hEnd - 24;
                            display.repaint();
                        }
                    }
                }
                // go forward one selection period : (->) key
                else if (kk == 39) {
                    if (!bannerOnly) {
                        if (hEnd + (hEnd - hStart) < (yearDays + 1) * 24) {
                            double tmp = hEnd;
                            hEnd = hEnd + (hEnd - hStart);
                            hStart = tmp;
                            display.repaint();
                        } else {
                            hStart = yearDays * 24 - (hEnd - hStart);
                            hEnd = (yearDays + 1) * 24;
                            display.repaint();
                        }
                    } else {
                        if (hEnd < (yearDays + 1) * 24) {
                            hStart = hStart + 24;
                            hEnd = hEnd + 24;
                            display.repaint();
                        }
                    }
                }
            }
        });

        // perform mouse action
        display.addMouseMotionListener(new java.awt.event.MouseAdapter() {
            // display numeric data online
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                int xPos = evt.getX();
                int yPos = evt.getY();
                if (yPos < y1T + y2T && yPos > y1T + 3) {
                    setCursor(new java.awt.Cursor(Cursor.CROSSHAIR_CURSOR));
                    double[] data = dataReverse(xPos, yPos);
                    String doy = String.format("%.0f", data[0]);
                    jLa_T.setText("date : " + DOYtoDate((int) data[0]) + " (" + doy + ")");
                    jLa_H.setText("time : " + decHourToString(data[3] + data[4] / 60));
                    if (palette < 4) {
                        double[] result =
                            calcSunPosition(stationLatVal, stationLonVal, stationYearVal, data[1], data[2], data[3],
                                            data[4], 0.0, stationZoneVal, stationDlsVal);
                        jLa_S.setText("sun az : " + String.format("%.0f", result[0]) + " alt : " +
                                      String.format("%.0f", result[1]) + "");
                    } else if (palette < 6) {
                        double[] result =
                            calcMoonPosition(stationLatVal, stationLonVal, stationYearVal, data[1], data[2], data[3],
                                             data[4], 0.0, stationZoneVal, stationDlsVal);
                        jLa_S.setText("moon alt : " + String.format("%.0f", result[1]) + " ph : " +
                                      String.format("%.1f", result[2]) + "");
                    } else {
                        double Gs =
                            getTransposition(stationLatVal, stationLonVal, stationAltVal, stationPazVal, stationIncVal,
                                             stationAlbedoVal, stationYearVal, data[1], data[2], data[3], data[4], 0,
                                             stationZoneVal, stationDlsVal);
                        jLa_S.setText("flux : " + String.format("%.0f", Gs) + " W/m");
                    }
                } else {
                    setCursor(new java.awt.Cursor(Cursor.DEFAULT_CURSOR));
                    jLa_T.setText(lT);
                    jLa_H.setText(lH);
                    jLa_S.setText(lS);
                }
            }
        });
        display.addMouseListener(new java.awt.event.MouseAdapter() {
            // select a zoom
            public void mousePressed(MouseEvent arg0) {
                xStart = arg0.getX();
                yStart = arg0.getY();
            }

            public void mouseReleased(MouseEvent arg0) {
                xAct = arg0.getX();
                yAct = arg0.getY();
                xdiff = Math.abs(xAct - xStart);
                ydiff = Math.abs(yAct - yStart);

                if (yAct < y1T + y2T) {
                    // scale BANNER to selected region
                    double[] data = dataReverse(xStart, yStart);
                    hStart = (int) data[0] * 24;
                    data = dataReverse(xStart + xdiff, yStart + ydiff);
                    stationMonthVal = (int) data[1];
                    stationDayVal = (int) data[2];
                    hEnd = Math.max((int) data[0] * 24, hStart + 24);
                    display.setVisible(false);
                    display.repaint();
                    display.setVisible(true);
                    //JOptionPane.showMessageDialog(null, String.format("%.0f", (double) xdiff) + ":" + String.format("%.0f", (double) ydiff));
                }
            }
        });
        
        // quit program
        twilight.this.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    /**
     * Get system date
     */
    public void getThisYear() {
        Date myDate = new Date();
        DateFormat df = DateFormat.getDateInstance(DateFormat.FULL, Locale.ENGLISH);
        String d4 = df.format(myDate);
        String[] dd = d4.split(" ");
        stationYear = dd[dd.length - 1];
        stationYearVal = Double.parseDouble(stationYear);
        stationMonth = dd[1]; // TODO
        stationDay = dd[0]; // TODO
        checkLeapYear();
    }
    
    /**
     * Check for leap year and adjust for Febrary 29
     */
    public void checkLeapYear() {
        int J[] = { 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365, 400 }; // cumulated days of month [d]
        if (stationYearVal / 4 - Math.floor(stationYearVal / 4) == 0) {
            yearDays = 366;
            for (int i = 0; i < JM.length; i++) {
                if (i > 1)
                    JM[i] = J[i] + 1;
                else
                    JM[i] = J[i];
            }
            System.out.println(stationYearVal + " is a leap year!");
        } else {
            yearDays = 365;
            for (int i = 0; i < JM.length; i++) {
                JM[i] = J[i];
            }
            System.out.println(stationYearVal + " is a non leap year!");
        }
        suncalc.setJM(JM); // forward new JM array to sunCalc class
        mooncalc.setJM(JM); // forward new JM array to moonCalc class
    }

    /**
     * Forwarding function
     */
    public double[] calcSunPosition(double lat, double lon, double year, double month, double day, double hours,
                                    double minutes, double seconds, double timezone,
                                    double dlstime) {
        // declaration classe transPos : geometrie solaire
        double[] result =
            suncalc.calcSunPosition(lat, lon, year, month, day, hours, minutes, seconds, timezone, dlstime,
                                    refractionOn);
        return result;
    }

    /**
     * Forwarding function
     */
    public double[] calcMoonPosition(double lat, double lon, double year, double month, double day, double hours,
                                     double minutes, double seconds, double timezone,
                                     double dlstime) {
        // declaration classe transPos : geometrie lune
        double[] result =
            mooncalc.calcMoonPosition(lat, lon, year, month, day, hours, minutes, seconds, timezone, dlstime,
                                      refractionOn);
        return result;
    }

    /**
     * Forwarding function
     */
    public double getTransposition(double lat, double lon, double alt, double paz, double inc, double albedo,
                                   double year, double month, double day, double hour, double min, double sec,
                                   double zone, double dls) {
        double Gs =
            suncalc.getTransposition(lat, lon, alt, paz, inc, albedo, year, month, day, hour, min, sec, zone, dls,
                                     horizonData);
        return Gs;
    }

    /**
     * Calculate date and time according to x/y position of cursor
     * @param xPos int : x position [pixels]
     * @param yPos int : y position [pixels]
     * @return double[] : {doy, month, day, hour, minute}
     */
    private double[] dataReverse(int xPos, int yPos) {
        // axe X
        xPos = Math.max(x1T, Math.min(xPos, x1T + x2T));
        double doy = Math.max(1, Math.round(yearDays * (xPos - x1T) / x2T));
        int m = 1;
        while (doy > JM[m])
            m++;
        double mm = m;
        double dd = Math.max(1, doy - JM[m - 1] + 1);

        // axe Y
        double time = Math.max(0, 24 * ((double) y2T - (yPos - (double) y1T)) / (double) y2T);
        double hh = Math.floor(time);
        double min = Math.floor((time - hh) * 60);

        double[] result = { doy, mm, dd, hh, min };
        return result;
    }

    /**
     * Transform day of yer (doy) to date
     * @param doy int : day of year
     * @return String : the date "mm dd"
     */
    public String DOYtoDate(int doy) {
        int m = 1;
        while (doy > JM[m])
            m++;
        int dd = doy - JM[m - 1];
        String mm = nomMois[m - 1];
        String result = mm + " " + dd;
        return result;
    }

    /**
     * Transform day of yer (doy) to day of month (dom)
     * @param doy int : day of year
     * @return String : the date "dd"
     */
    public String DOYtoDOM(int doy) {
        int m = 1;
        while (doy > JM[m])
            m++;
        int dd = doy - JM[m - 1];
        String result = dd + "";
        return result;
    }

    /**
     * Inner class for canvas object on which to draw data <br>
     * graphic output (twilight diagram) + the rest
     */
    class myDisplay extends Canvas {
        public void paint(Graphics g) {
            ((Graphics2D) g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g.setFont(tableFont);

            // get window size to adjust graphs
            int imgX = twilight.this.getWidth() - 16;
            int imgY = twilight.this.getHeight() - 61;
            
            // set GRAPH dimensions [px]
            x1T = 0; // position x
            y1T = 0; // position y
            x2T = imgX; // width
            y2T = (int) (imgY * 0.75); // heigth
            
            // set BANNER dimensions [px]
            if (!bannerOnly) {
                x1Z = x1T; // position x
                y1Z = y2T + (int) (0.04 * imgY); //y2T + 20; // position y
                x2Z = x2T; // width
                y2Z = (int) (imgY * 0.15); // heigth
                jPa_0.setBounds(imgX - 160, y2T - 60, 120, 35); // data label
                jPa_0.setVisible(true); // data label
            } else {
                x1Z = x1T; // position x
                y1Z = y1T; // position y
                x2Z = x2T; // width
                y2Z = (int) (imgY * 0.85); // heigth
                jPa_0.setVisible(false); // data label
            }
            
            // init external classes
            sunCalc suncalc = null;
            suncalc = new sunCalc();
            suncalc.setJM(JM); // forward JM to sunCalc class
            
            moonCalc mooncalc = null;
            mooncalc = new moonCalc();
            mooncalc.setJM(JM); // forward JM to moonCalc class
            
            // list of offsets for hour inventory (year)
            double[][] sunSum = { { 0, 0 }, { -6, 0 }, { -12, 0 }, { -18, 0 }, { -90, 0 } }; // suns altitude
            double[][] sunDay = { { 0, 0 }, { -6, 0 }, { -12, 0 }, { -18, 0 }, { -90, 0 } }; // days
            String[] sunLabel = {
                "Sun visible   ", "Civil twilight", "Nautical      ", "Astronomical  ", "Dark night    " };
            String[] sunLabelShort = { "  sun", "civil", "nauti", "astro", " dark" };
            double[][] fluxSum = {
                { 150, 0, 0 }, { 350, 0, 0 }, { 500, 0, 0 }, { 650, 0, 0 }, { 800, 0, 0 }, { 1000, 0, 0 },
                { 2000, 0, 0 }
            }; // flux solaires
            String[] fluxLabel = {
                "< 150 W/m   ", "150-350 W/m ", "350-500 W/m ", "500-650 W/m ", "650-800 W/m ", "800-1000 W/m",
                "> 1000 W/m  "
            };


            // ============================
            //       ANNUAL graph
            // ============================
            
            if (!bannerOnly) {
                // draw twilight/sun/moon altitudes
                ((Graphics2D) g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                double hIncr = 0.25; // make 15' steps
                int rectX = (int) (x2T / yearDays) + 1; //3; // pixel size X (px)
                int rectY = (int) (y2T / (24 / hIncr)) + 1;//4; // pixel size Y (px)
                for (double h = 0; h < (yearDays * 24); h += hIncr) {
                    double[] date = suncalc.HOYtoDate(h);
                    double[] sunPos =
                        suncalc.calcSunPosition(stationLatVal, stationLonVal, stationYearVal, date[0], date[1], date[2],
                                                date[3], 0.0, stationZoneVal, stationDlsVal, refractionOn);
                    double[] moonPos =
                        mooncalc.calcMoonPosition(stationLatVal, stationLonVal, stationYearVal, date[0], date[1], date[2],
                                                  date[3], 0.0, stationZoneVal, stationDlsVal, refractionOn);
                    double Gs;
                    if (obstruct)
                        Gs =
                            suncalc.getTransposition(stationLatVal, stationLonVal, stationAltVal, stationPazVal,
                                                     stationIncVal, stationAlbedoVal, stationYearVal, date[0], date[1],
                                                     date[2], date[3], 0.0, stationZoneVal, stationDlsVal, horizonData);
                    else
                        Gs =
                            suncalc.getTransposition(stationLatVal, stationLonVal, stationAltVal, stationPazVal,
                                                     stationIncVal, stationAlbedoVal, stationYearVal, date[0], date[1],
                                                     date[2], date[3], 0.0, stationZoneVal, stationDlsVal);
                    double Ha = suncalc.getHorizonAngle(sunPos[0], horizonData);
                    if (palette < 4) {
                        Color col = getColor(sunPos[1], palette);
                        if (palette == 0 && sunPos[1] < 0 && moonPos[1] > 0) {
                            Color moonCol = colorCalc(moonPos[2], colorMoon, setMoon, false);
                            int sSun = (col.getRed() + col.getGreen() + col.getBlue());
                            int sMoon = (moonCol.getRed() + moonCol.getGreen() + moonCol.getBlue());
                            if (sSun < sMoon) {
                                col = moonCol;
                            }
                        }
                        if (sunPos[1] > Ha || !obstruct)
                            g.setColor(col);
                        else if (sunPos[1] > -1) {
                            int sx = (col.getRed() + col.getGreen() + col.getBlue()) / 3; // desaturation (obstructions)
                            g.setColor(new Color(sx, sx, sx));
                        } else
                            g.setColor(col);
                    } else if (palette < 6) {
                        Color col = getColor(moonPos[1], palette);
                        int sr = (int) (col.getRed() * moonPos[2]);
                        int sg = (int) (col.getGreen() * moonPos[2]);
                        int sb = (int) (col.getBlue() * moonPos[2]);
                        g.setColor(new Color(sr, sg, sb));
                    } else {
                        g.setColor(getColor(Gs, palette)); // use solar irradiation
                    }
                    
                    if (!bannerOnly) {
                        double xx = x1T + (int) (h / 24) * x2T / yearDays;
                        double yy = y1T + y2T - (h - (int)(h / 24) * 24) * y2T / 24 - rectY;
                        g.fillRect((int) xx, (int) yy, rectX, rectY);
                    }
    
                    // count night / twilight / day hours
                    if (sunPos[1] > 0) {
                        if (obstruct && sunPos[1] > Ha)
                            sunSum[0][1] += hIncr;
                        else if (!obstruct)
                            sunSum[0][1] += hIncr;
                    }
                    for (int i = 1; i < sunSum.length; i++) {
                        if (sunPos[1] < 0 && sunPos[1] > sunSum[i][0]) {
                            sunSum[i][1] += hIncr;
                            break;
                        }
                    }
    
                    // inventaire heures par tranche d'intensit de flux solaire
                    for (int i = 0; i < fluxSum.length; i++) {
                        if (Gs < fluxSum[i][0]) {
                            fluxSum[i][1] += hIncr;
                            fluxSum[i][2] += Gs * hIncr;
                            break;
                        }
                    }
                }
    
                // draw grid
                g.setColor(Color.gray);
                for (int m = 0; m < 11; m++) {
                    int d = suncalc.dateToDOY(m + 1, 1);
                    int xx = x1T + (int) d * x2T / (int) yearDays;
                    g.drawLine(xx, y1T, xx, y1T + y2T);
                }
                for (int h = 0; h < 24; h += 3) {
                    int yy = y1T + h * y2T / 24;
                    g.drawLine(x1T, yy, x2T, yy);
                }
                
                // draw moon phases
                if (palette == 4 || palette == 5) {
                    ((Graphics2D) g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int moonDiam = 12; // moon diameter in px
                    hIncr = (double) x2T / (yearDays * 24 * 2);
                    double phaseOld = 0;
                    double moonPosOldOld = 0;
                    double moonPosOld = 0;
                    for (double h = 0; h < (yearDays * 24); h += hIncr) {
                        double xx = x1T + Math.floor(h / 24) * x2T / yearDays - moonDiam / 2;
                        //double yy = y1T + y2T - 10 - moonDiam / 2; // draw on bottom line
                        double yy = y1T + y2T - (h - Math.floor(h / 24) * 24) * y2T / 24 - moonDiam / 2; // draw at proper time
                        double[] date = suncalc.HOYtoDate(h);
                        double[] moonPos =
                        mooncalc.calcMoonPosition(stationLatVal, stationLonVal, stationYearVal, date[0], date[1], date[2],
                                                  date[3], 0.0, stationZoneVal, stationDlsVal, refractionOn);
                        if (palette == 4) {
                            if (moonPos[3] < phaseOld || phaseOld < 6 && moonPos[3] > 6 ||
                                phaseOld < 12 && moonPos[3] > 12 || phaseOld < 18 && moonPos[3] > 18) {
                                drawMoon(g, 12, xx, yy, moonPos[3]);
                            }
                        } else if (moonPosOld + 0.0001 > moonPosOldOld && moonPosOld + 0.0001 > moonPos[1]) {
                            drawMoon(g, 12, xx, yy, moonPos[3]);
                        }
                        phaseOld = moonPos[3];
                        moonPosOldOld = moonPosOld;
                        moonPosOld = moonPos[1];
                    }
                    ((Graphics2D) g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
    
                // draw a frame around graph area
                g.setColor(Color.BLACK);
                g.drawRect(x1T - 1, y1T - 1, x1T + x2T + 1, y1T + y2T + 1);
    
                // draw a box around selection and zoom lines
                double xx = x1T + x2T * hStart / (yearDays * 24);
                double xl = x2T * (hEnd - hStart) / (yearDays * 24);
                g.setColor(Color.red);
                g.drawRect((int) xx, y1T, (int) xl, y2T);
                g.drawLine((int) xx, y2T, x1Z, y1Z);
                g.drawLine((int) (xx + xl), y2T, x1T + x2T, y1Z);
    
                // draw legends
                ((Graphics2D) g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (int h = 0; h < 24; h += 3) {
                    g.setColor(Color.black);
                    g.drawString(String.format("%.0f", (double) h) + "h", x1T + x2T - 25 + 1,
                                 y1T + y2T - h * y2T / 24 - 5 + 1);
                    g.setColor(tableColor);
                    g.drawString(String.format("%.0f", (double) h) + "h", x1T + x2T - 25, y1T + y2T - h * y2T / 24 - 5);
                }
                g.setColor(tableColor);
                for (double m = 0; m < 12; m++) {
                    g.setColor(Color.black);
                    g.drawString(nomMois[(int) m], x1T + (int) m * x2T / 12 + 5 + 1, y1T + y2T - 5 + 1);
                    g.setColor(tableColor);
                    g.drawString(nomMois[(int) m], x1T + (int) m * x2T / 12 + 5, y1T + y2T - 5);
                }
    
                // draw selection info
                g.setColor(tableColor);
                if (obstruct)
                    g.drawString("obstructions ON", x1T + x2T - 120, 15);
                else
                    g.drawString("obstructions OFF", x1T + x2T - 120, 15);
                g.setColor(tableColor);
                if (stationIncVal > 0 && palette > 5)
                    g.drawString("SIM : az " + String.format("%.0f", stationPazVal) + " inc " +
                                 String.format("%.0f", stationIncVal) + "", x1T + x2T - 155, 25);
                if (stationAlbedoVal != 0.15)
                    g.drawString("albedo : " + String.format("%.2f", stationAlbedoVal), x1T + x2T - 120, 35);
    
                // draw station data
                g.setColor(tableColor);
                g.drawString("File path name : " + stationFn, (int) (x1T + 5), (int) (y1T + 0) + y1T + 12);
                g.drawString("Station name : " + stationName + " (" + stationCountry + ")", (int) (x1T + 5),
                             (int) (y1T + 10) + y1T + 12);
                g.drawString("Latitude  : " + stationLat + "", (int) (x1T + 5), (int) (y1T + 20) + y1T + 12);
                g.drawString("Longitude : " + stationLon + "", (int) (x1T + 5), (int) (y1T + 30) + y1T + 12);
                g.drawString("Altitude  : " + stationAlt + "m", (int) (x1T + 5), (int) (y1T + 40) + y1T + 12);
                g.drawString("Time zone : " + stationZone, (int) (x1T + 5), (int) (y1T + 50) + y1T + 12);
                g.drawString(appName + " - " + appVersion, (int) (x1T + 5), (int) (y1T + 60) + y1T + 12);
    
                // draw year
                g.setFont(new Font("lucida console", Font.BOLD, 18));
                g.setColor(Color.black);
                g.drawString(String.format("%.0f", stationYearVal), (int) (x1T + x2T / 2) - 24, (int) (y1T + 18));
                g.setColor(tableColor);
                g.drawString(String.format("%.0f", stationYearVal), (int) (x1T + x2T / 2) - 25, (int) (y1T + 18));
                g.setFont(tableFont);
    
                // draw hour analysis
                if (palette < 4) {
                    for (int i = 0; i < sunSum.length; i++) {
                        g.drawString(sunLabel[i] + " : " + String.format("%.0f", (double) (sunSum[i][1] * 100 / (yearDays * 24))) +
                                     "%", (int) (x1T + 5), (int) (y1T + y2T - 60 + i * 10));
                    }
                } else if (palette < 6) {
                    // TODO ***
    
    
                } else {
                    double yTotal = 0;
                    for (int i = 0; i < fluxSum.length; i++) {
                        yTotal += fluxSum[i][2];
                        String txt = fluxLabel[i] + " : " + String.format("%.0f", (double) (fluxSum[i][1])) + "h - ";
                        txt = txt + String.format("%.0f", (double) (fluxSum[i][2] / 1000)) + "kWh";
                        g.drawString(txt, x1T + 5, y1T + y2T - 75 + i * 10);
                    }
                    g.drawString("Clear sky potentiel : " + String.format("%.0f", (double) (yTotal / 1000)) + "kWh/year",
                                 x1T + 5, y1T + y2T - 85);
                }
            }


            // ============================
            //            BANNER
            // ============================
            
            if (bannerOnly || !bannerOnly) {
                // draw lines -6 / -12 / -18
                g.setColor(Color.lightGray);
                g.drawLine(x1Z, y1Z + y2Z + 6 * y2Z / 90, x1Z + x2Z, y1Z + y2Z + 6 * y2Z / 90);
                g.drawLine(x1Z, y1Z + y2Z + 12 * y2Z / 90, x1Z + x2Z, y1Z + y2Z + 12 * y2Z / 90);
                g.drawLine(x1Z, y1Z + y2Z + 18 * y2Z / 90, x1Z + x2Z, y1Z + y2Z + 18 * y2Z / 90);
    
                double[] sunWeek = new double[370]; // inventaire heures de soleil par jour
    
                // draw banner
                double hStep = (hEnd - hStart) / x2Z; // calculate appropriate time step
                double bannerScale = (double) y2Z / 90;
                for (double h = hStart; h < hEnd; h += hStep) {
                    double[] date = suncalc.HOYtoDate(h);
                    double[] sunPos =
                        suncalc.calcSunPosition(stationLatVal, stationLonVal, stationYearVal, date[0], date[1], date[2],
                                                date[3], 0, stationZoneVal, stationDlsVal, refractionOn);
                    double Ha = suncalc.getHorizonAngle(sunPos[0], horizonData);
                    double[] moonPos =
                        mooncalc.calcMoonPosition(stationLatVal, stationLonVal, stationYearVal, date[0], date[1], date[2],
                                                  date[3], 0.0, stationZoneVal, stationDlsVal, refractionOn);
                    if (palette < 4) {
                        Color col = getColor(sunPos[1], palette);
                        if (palette == 0 && sunPos[1] < 0 && moonPos[1] > 0) {
                            Color moonCol = colorCalc(moonPos[2], colorMoon, setMoon, false);
                            int sSun = (col.getRed() + col.getGreen() + col.getBlue());
                            int sMoon = (moonCol.getRed() + moonCol.getGreen() + moonCol.getBlue());
                            if (sSun < sMoon)
                                col = moonCol;
                        }
                        if (sunPos[1] > Ha || !obstruct)
                            g.setColor(col);
                        else if (sunPos[1] > -1) {
                            int sx = (col.getRed() + col.getGreen() + col.getBlue()) / 3; // desaturation
                            g.setColor(new Color(sx, sx, sx));
                        } else
                            g.setColor(col);
                    } else if (palette < 6) {
                        Color col = getColor(moonPos[1], palette);
                        int sr = (int) (col.getRed() * moonPos[2]);
                        int sg = (int) (col.getGreen() * moonPos[2]);
                        int sb = (int) (col.getBlue() * moonPos[2]);
                        g.setColor(new Color(sr, sg, sb));
                    } else {
                        double Gs;
                        double[] date1 = suncalc.HOYtoDate(h);
                        if (obstruct)
                            Gs =
                                suncalc.getTransposition(stationLatVal, stationLonVal, stationAltVal, stationPazVal,
                                                         stationIncVal, stationAlbedoVal, stationYearVal, date1[0],
                                                         date1[1], date1[2], date1[3], 0.0, stationZoneVal, stationDlsVal,
                                                         horizonData);
                        else
                            Gs =
                                suncalc.getTransposition(stationLatVal, stationLonVal, stationAltVal, stationPazVal,
                                                         stationIncVal, stationAlbedoVal, stationYearVal, date1[0],
                                                         date1[1], date1[2], date1[3], 0.0, stationZoneVal, stationDlsVal);
                        g.setColor(getColor(Gs, palette));
                    }
                    
                    // dessine la ligne verticale
                    double xx = x1Z + (h - hStart) * x2Z / (hEnd - hStart);
                    g.drawRect((int) xx, y1Z, 1, y2Z);
                    
                    if (hEnd - hStart == 24) { // one day
                        // inventaire heures de nuit / crepuscule / soleil
                        if (sunPos[1] > 0) {
                            if (obstruct && sunPos[1] > Ha)
                                sunDay[0][1] += hStep;
                            else if (!obstruct)
                                sunDay[0][1] += hStep;
                        }
                        for (int i = 1; i < sunDay.length; i++) {
                            if (sunPos[1] < 0 && sunPos[1] > sunDay[i][0]) {
                                sunDay[i][1] += hStep;
                                break;
                            }
                        }
                    } else { // several days
                        if (sunPos[1] > 0) {
                            if (obstruct && sunPos[1] > Ha)
                                sunWeek[(int) (h - hStart) / 24] += hStep;
                            else if (!obstruct)
                                sunWeek[(int) (h - hStart) / 24] += hStep;
                        }
                    }
    
                    // draw horizon
                    if (obstruct) {
                        g.setColor(Color.darkGray);
                        g.drawRect((int) xx, y1Z + y2Z - (int) (Ha * bannerScale), 0, (int) (Ha * bannerScale));
                    }
                    
                    // draw moon course
                    if (palette == 0 || palette == 1 || palette == 4 || palette == 5) {
                        if (moonPos[1] >= 0) {
                            g.setColor(Color.white);
                        } else {
                            g.setColor(Color.black);
                        }
                        g.drawRect((int) xx, y1Z + y2Z - (int) (moonPos[1] * bannerScale), 0, 0);
                    }
                    
                    // draw sun course
                    if (palette != 4 && palette != 5) { // sun
                        if (sunPos[1] >= 0) {
                            g.setColor(Color.red);
                        } else {
                            g.setColor(Color.black);
                        }
                        g.drawRect((int) xx, y1Z + y2Z - (int) (sunPos[1] * bannerScale), 0, 0);
                    }
                }
                
                // draw lines +12 / 0
                g.setColor(Color.lightGray);
                g.drawLine(x1Z, y1Z + y2Z - 12 * y2Z / 90, x1Z + x2Z, y1Z + y2Z - 12 * y2Z / 90);
                g.drawLine(x1Z, y1Z + y2Z - 0 * y2Z / 90, x1Z + x2Z, y1Z + y2Z - 0 * y2Z / 90);
    
                ((Graphics2D) g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

                // draw sun
                if (palette != 4 && palette != 5) {
                    double sunDiam = 12; // sun diameter px
                    double sunPosOld = 0;
                    double sunPosOldOld = 0;
                    double sStep = Math.min(hStep, 0.5);
                    for (double h = hStart; h < hEnd; h += sStep) {
                        double xx = x1Z + (h - hStart) * x2Z / (hEnd - hStart);
                        double[] date = suncalc.HOYtoDate(h);
                        double[] sunPos =
                            suncalc.calcSunPosition(stationLatVal, stationLonVal, stationYearVal, date[0], date[1], date[2],
                                                      date[3], 0.0, stationZoneVal, stationDlsVal, refractionOn);
                        if (sunPosOldOld != 0 && sunPosOld + 0.0001 > sunPosOldOld && sunPosOld + 0.0001 > sunPos[1]) {
                            double sx = xx - sunDiam / 2;
                            double sy = y1Z + y2Z - (sunPos[1] * bannerScale) - sunDiam / 2;
                            drawSun(g, 12, sx, sy, sunPos[1]);
                        }
                        sunPosOldOld = sunPosOld;
                        sunPosOld = sunPos[1];
                    }
                }
                
                // draw moon
                if (palette == 0 || palette == 1 || palette == 4 || palette == 5) {
                    double moonDiam = 12; // moon diameter px
                    double moonPosOldOld = 0;
                    double moonPosOld = 0;
                    double mStep = Math.min(hStep, 0.5);
                    for (double h = hStart; h < hEnd; h += mStep) {
                        double xx = x1Z + (h - hStart) * x2Z / (hEnd - hStart);
                        double[] date = suncalc.HOYtoDate(h);
                        double[] moonPos =
                            mooncalc.calcMoonPosition(stationLatVal, stationLonVal, stationYearVal, date[0], date[1], date[2],
                                                      date[3], 0.0, stationZoneVal, stationDlsVal, refractionOn);
                        if (moonPosOldOld != 0 && moonPosOld + 0.0001 > moonPosOldOld && moonPosOld + 0.0001 > moonPos[1]) {
                            double mx = xx - moonDiam / 2;
                            double my = y1Z + y2Z - (int) (moonPos[1] * bannerScale) - moonDiam / 2;
                            drawMoon(g, 12, mx, my, moonPos[3]);
                        }
                        moonPosOldOld = moonPosOld;
                        moonPosOld = moonPos[1];
                    }
                }
                
                // draw if selection = one day
                if (hEnd - hStart == 24) {
                    // draw hourlines
                    int yH;
                    for (double min = 0; min < 1440; min += 10) {
                        g.setColor(Color.gray);
                        if (min / 180 == Math.floor(min / 180)) {
                            yH = y1Z + 20;
                            double xx = (double) x1Z + ((double) x1Z + (double) x2Z) / 1440 * min + 5;
                            g.setColor(Color.black);
                            g.drawString(String.format("%.0f", min / 60) + "h", (int) xx + 1, y1Z + 15 + 1);
                            g.setColor(Color.white);
                            g.drawString(String.format("%.0f", min / 60) + "h", (int) xx, y1Z + 15);
                            g.setColor(Color.gray);
                        } else if (min / 60 == Math.floor(min / 60))
                            yH = y1Z + 10;
                        else
                            yH = y1Z + 4;
                        double xL = (double) x1Z + ((double) x1Z + (double) x2Z) / 1440 * min;
                        g.drawLine((int) xL, y1Z, (int) xL, yH);
                    }
    
                    // label declination
                    double[] date1 = suncalc.HOYtoDate(hStart);
                    if (palette < 2) { // label twilight
                        g.setColor(tableColor);
                        for (int i = 0; i < sunDay.length; i++) {
                            g.drawString(sunLabelShort[i] + " " + decHourToString(sunDay[i][1]), x1Z + +x2Z - 85,
                                         y1Z + 22 + i * 10);
                        }
                    } else if (palette < 4) { // label solar altitude
                        double poleDist = Math.abs(stationLatVal - 90) * 60 * 1.852; // distance to pole in km
                        double equDist = Math.abs(stationLatVal) * 60 * 1.852; // distance to equator in km
                        double dec =
                  suncalc.calcSunDeclination(stationYearVal, date1[0], date1[1], date1[2], date1[3], 0.0, stationZoneVal,
                                             stationDlsVal);
                        g.setColor(tableColor);
                        g.drawString("pole = " + String.format("%.0f", poleDist) + "km", x1Z + +x2Z - 100, y1Z + y2Z - 33);
                        g.drawString("equ  = " + String.format("%.0f", equDist) + "km", x1Z + +x2Z - 100, y1Z + y2Z - 23);
                        g.drawString("dec  = " + String.format("%.1f", dec) + "", x1Z + +x2Z - 100, y1Z + y2Z - 13);
                    } else if (palette < 6) {
                        // TODO ***
    
                    } else { // label transposition day
                        double Gs;
                        if (obstruct)
                            Gs =
                                suncalc.getTransPositionDoy(stationLatVal, stationLonVal, stationAltVal, stationPazVal,
                                                            stationIncVal, stationAlbedoVal, stationYearVal, date1[0],
                                                            date1[1], stationZoneVal, stationDlsVal, horizonData);
                        else
                            Gs =
                                suncalc.getTranspositionDoy(stationLatVal, stationLonVal, stationAltVal, stationPazVal,
                                                            stationIncVal, stationAlbedoVal, stationYearVal, date1[0],
                                                            date1[1], stationZoneVal, stationDlsVal);
    
                        g.setColor(tableColor);
                        g.drawString(String.format("%.1f", (double) Gs / 1000) + "kWh/m", x1Z + +x2Z - 70, y1Z + y2Z - 13);
                    }
    
                    // label date
                    String date = DOYtoDate((int) hStart / 24);
                    g.setColor(Color.black);
                    g.drawString(date, x1Z + 5 + 1, y1Z + y2Z - 13 + 1);
                    g.setColor(tableColor);
                    g.drawString(date, x1Z + 5, y1Z + y2Z - 13);
    
                    // labels rise / set / twilight
                    if (palette != 4 && palette != 5) {
                        g.setColor(Color.lightGray); // yellow
                        double[] data = new double[9];
                        String[] dataLabel = {
                            "astro", "nauti", "civil", "sunrise", " noon", "sunset", "civil", "nauti", "astro" };
                        data[0] =
                            suncalc.calcDawn(stationLatVal, stationLonVal, stationYearVal, stationMonthVal, stationDayVal,
                                             stationZoneVal, stationDlsVal, 18);
                        data[1] =
                            suncalc.calcDawn(stationLatVal, stationLonVal, stationYearVal, stationMonthVal, stationDayVal,
                                             stationZoneVal, stationDlsVal, 12);
                        data[2] =
                            suncalc.calcDawn(stationLatVal, stationLonVal, stationYearVal, stationMonthVal, stationDayVal,
                                             stationZoneVal, stationDlsVal, 6);
                        data[3] =
                            suncalc.calcSunrise(stationLatVal, stationLonVal, stationYearVal, stationMonthVal,
                                                stationDayVal, stationZoneVal, stationDlsVal);
                        data[4] =
                            suncalc.calcSolarNoon(stationLatVal, stationLonVal, stationYearVal, stationMonthVal,
                                                  stationDayVal, stationZoneVal, stationDlsVal);
                        data[5] =
                            suncalc.calcSunset(stationLatVal, stationLonVal, stationYearVal, stationMonthVal, stationDayVal,
                                               stationZoneVal, stationDlsVal);
                        data[6] =
                            suncalc.calcDusk(stationLatVal, stationLonVal, stationYearVal, stationMonthVal, stationDayVal,
                                             stationZoneVal, stationDlsVal, 6);
                        data[7] =
                            suncalc.calcDusk(stationLatVal, stationLonVal, stationYearVal, stationMonthVal, stationDayVal,
                                             stationZoneVal, stationDlsVal, 12);
                        data[8] =
                            suncalc.calcDusk(stationLatVal, stationLonVal, stationYearVal, stationMonthVal, stationDayVal,
                                             stationZoneVal, stationDlsVal, 18);
                        for (int i = 0; i < data.length; i++) {
                            int xt;
                            int yt;
                            if (i < 3) {
                                xt = x1Z + 5;
                                yt = imgY - 5 - i * 10;
                            } else if (i > 5) {
                                xt = x1Z + x2Z - 85;
                                yt = imgY - 5 - (i - 6) * 10;
                            } else {
                                xt = x1Z + x2Z / 2 - 140 + (i - 3) * 120;
                                yt = imgY - 5;
                            }
                            g.drawString(dataLabel[i] + " " + decHourToString(data[i] * 24), xt, yt);
                        }
                    }
                }
                // selection = 2 to 14 days
                else if ((hEnd - hStart) / 24 < 15) {
                    int dStart = (int) Math.floor(hStart / 24);
                    int dEnd = (int) Math.floor(hEnd / 24);
                    int cnt = 0;
                    for (int d = dStart; d <= dEnd; d++) {
                        String date = DOYtoDate(d);
                        int x = x1Z + cnt * (x2Z / (dEnd - dStart)) + (x2Z / (dEnd - dStart) / 2) - 15;
                        g.setColor(Color.black);
                        g.drawString(date, x + 1, y1Z + 10 + 1);
                        g.setColor(tableColor);
                        g.drawString(date, x, y1Z + 10);
                        if (palette < 4) {
                            g.setColor(Color.black);
                            g.drawString(decHourToString(sunWeek[(int) (d - dStart)]), x + 5 + 1, y1Z + 20 + 1);
                            g.setColor(tableColor);
                            g.drawString(decHourToString(sunWeek[(int) (d - dStart)]), x + 5, y1Z + 20);
                        }
                        cnt++;
                    }
                    // random maxime
                    g.setColor(Color.lightGray);
                    int rnd = (int) (Math.random() * maxime.length);
                    g.drawString(maxime[rnd], (x1Z + x2Z) / 2 - 200, imgY - 5);
                }
                // selection > 15 days
                else {
                    int dStart = (int) Math.floor(hStart / 24);
                    int dEnd = (int) Math.floor(hEnd / 24);
                    String date = "Overview from " + stationYear + " " + DOYtoDate(dStart) + " to " + DOYtoDate(dEnd - 1);
                    g.setColor(Color.black);
                    g.drawString(date, (x1Z + x2Z) / 2 - 134, imgY - 4);
                    g.setColor(tableColor);
                    g.drawString(date, (x1Z + x2Z) / 2 - 135, imgY - 5);
                    
                    // selection < 61 days
                    if ((hEnd - hStart) / 24 < 62) {
                        int cnt = 0;
                        for (int d = dStart; d <= dEnd - 1; d++) {
                            date = DOYtoDOM(d);
                            int x = x1Z + (int) (cnt * ((double) x2Z / (dEnd - dStart))) + (x2Z / (dEnd - dStart) / 2) - 5;
                            g.setColor(Color.black);
                            g.drawString(date, x + 1, y1Z + 10 + 1);
                            g.setColor(tableColor);
                            g.drawString(date, x, y1Z + 10);
                            cnt++;
                        }
                    }
                }
            }

            ((Graphics2D) g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        
        /**
         * Draw the sun
         * @param g canvas object
         * @param sunDiam int : diameter in px
         * @param xx double : horizontal pos in px
         * @param yy double : vertical pos in px
         * @param alt double : sun altitude in deg
         */
        private void drawSun(Graphics g, int sunDiam, double xx, double yy, double alt) {
            g.setColor(Color.black);
            g.fillOval((int) xx, (int) yy, sunDiam, sunDiam);
            int pal = palette;
            if (palette > 3)
                pal = 0;
            Color col = getColor(alt, pal);
            g.setColor(col);
            g.fillOval((int) xx + 1, (int) yy + 1, sunDiam - 2, sunDiam - 2);
        }
        
        /**
         * Draw the moon
         * @param g canvas object
         * @param moonDiam int : diameter in px
         * @param xx double : horizontal pos in px
         * @param yy double : vertical pos in px
         * @param ph double : moon phase (0 = new moon to 12 = full moon to 24)
         */
        private void drawMoon(Graphics g, int moonDiam, double xx, double yy, double ph) {
            moonDiam = moonDiam -2;
            Color shadeCol = new Color(30, 30, 30);
            Color moonCol = Color.white;
            g.setColor(Color.black);
            g.fillOval((int) xx - 1, (int) yy - 1, moonDiam + 2, moonDiam + 2); // background
            g.setColor(moonCol);
            g.fillOval((int) xx, (int) yy, moonDiam, moonDiam);
            int dd = 0;
            
            // new moon
            if (ph < 0.5 || ph > 23.5) {
                g.setColor(shadeCol);
                g.fillOval((int) xx, (int) yy, moonDiam, moonDiam);
            }
            // full moon
            else if (ph > 11.5 && ph < 12.5) {
                // nothing to do; its already full!
            }
            // first quarter
            else if (ph < 6 || ph > 18) {
                g.setColor(shadeCol);
                if (ph < 6) {
                    g.fillArc((int) xx, (int) yy, moonDiam, moonDiam, 90, 180);
                    dd = (int) ((6.0 - ph) / 6.0 * moonDiam / 2);
                } else {
                    g.fillArc((int) xx, (int) yy, moonDiam, moonDiam, 90, -180);
                    dd = (int) ((ph - 18) / 6.0 * moonDiam / 2);
                }
                g.fillOval((int) xx + moonDiam / 2 - dd, (int) yy, dd * 2, moonDiam);
            }
            // last quarter
            else {
                g.setColor(shadeCol);
                if (ph < 12) {
                    g.fillArc((int) xx, (int) yy, moonDiam, moonDiam, 90, 180);
                    dd = (int) ((ph - 6.0) / 6.0 * moonDiam / 2);
                } else {
                    g.fillArc((int) xx, (int) yy, moonDiam, moonDiam, 90, -180);
                    dd = (int) ((18.0 - ph) / 6.0 * moonDiam / 2);
                }
                g.setColor(moonCol);
                g.fillOval((int) xx + moonDiam / 2 - dd, (int) yy, dd * 2, moonDiam);
            }
        }
    }


    /**
     * Convert decimal time to formatted string (hh:mm)
     * @param decTime double : time as decimal number
     * @return String : formatted text (hh:mm)
     */
    String decHourToString(double decTime) {
        decTime = Math.min(decTime, 24);
        double hh = Math.floor(decTime);
        double mm = (decTime - hh) * 60;
        if (mm > 59.4) {
            mm = 0;
            hh++;
        }
        String lS = "";
        if (hh < 10)
            lS = " ";
        String lZ = "";
        if (mm < 10)
            lZ = "0";
        String hhmm = lS + String.format("%.0f", (double) hh) + ":" + lZ + String.format("%.0f", (double) mm);
        return hhmm;
    }

    /**
     * Read and transform horizon data in to angular data
     * @param horizonFile double[][] : table contenant les donnes en provenance du fichier station
     * @param hObs double : hauteur de l'observateur au dessus du referentiel
     * @return
     */
    double[][] calcHorizonAngleTable(double[][] horizonFile, double hObs) {
        int length = (int) horizonFile[3][1];
        double[][] horList = new double[length + 2][length + 2]; // liste des paires angle az[0] / hauteur[1]

        // tranfer data tables to calculation tables while overlapping az = 0 (north)
        horList[0][0] = horizonFile[0][length - 1] - 360;
        horList[1][0] = Math.atan((horizonFile[1][length - 1] - hObs) / horizonFile[2][length - 1]) * 180 / Math.PI;
        for (int i = 0; i < length; i++) {
            horList[0][i + 1] = horizonFile[0][i];
            horList[1][i + 1] = Math.atan((horizonFile[1][i] - hObs) / horizonFile[2][i]) * 180 / Math.PI;
        }
        horList[0][length - 1] = horizonFile[0][0] + 360;
        horList[1][length - 1] = Math.atan((horizonFile[1][0] - hObs) / horizonFile[2][0]) * 180 / Math.PI;

        return horList;
    }

    /**
     * Return colour of point using system palette : <br>
     * - colorSet -> see INIT section<br>
     * - tempSet -> see INIT section<br>
     * @param val double : numerical value of point
     * @return col Color : couleur Color(r, g, b)
     */
    Color getColor(double val) {
        Color col = getColor(val, palette);
        return col;
    }

    /**
     * Return colour of point using one of the system color palettes : <br>
     * - colorSet -> see INIT section<br>
     * - tempSet -> see INIT section<br>
     * @param val double : numerical value of point
     * @param palette int : palette ID
     * @return col Color : colour Color(r, g, b)
     */
    Color getColor(double val, int palette) {
        Color[] colorSetTmp = new Color[colorSet[palette].length];
        double[] tempSetTmp = new double[tempSet[palette].length];
        for (int j = 0; j < tempSet[palette].length; j++) {
            tempSetTmp[j] = tempSet[palette][j];
            colorSetTmp[j] = colorSet[palette][j];
        }
        Color col = colorCalc(val, colorSetTmp, tempSetTmp, palDiscrete[palette]);
        return col;
    }

    /**
     * Calculate colour of point
     * @param val double : numerical value of point to color
     * @param colorSet Color[] : array with list of colors
     * @param tempSet double[] : array with corresponding according values
     * @param palDiscrete boolean : discrete (true) or interpolated (false) colours
     * @return col Color : colour Color(r, g, b)
     */
    Color colorCalc(double val, Color[] colorSet, double[] tempSet, boolean palDiscrete) {
        // interpolation des couleurs a partir de T
        int r0 = 0;
        int g0 = 0;
        int b0 = 0;
        int r1 = 0;
        int g1 = 0;
        int b1 = 0;
        int rx = 0;
        int gx = 0;
        int bx = 0;
        double m = 0;
        double b = 0;
        if (palDiscrete) {
            for (int j = 1; j < colorSet.length; j++) {
                if (val < tempSet[j]) {
                    rx = colorSet[j - 1].getRed();
                    gx = colorSet[j - 1].getGreen();
                    bx = colorSet[j - 1].getBlue();
                    break;
                }
            }
        } else {
            for (int j = 1; j < colorSet.length; j++) {
                if (val < tempSet[j]) {
                    r0 = colorSet[j - 1].getRed();
                    g0 = colorSet[j - 1].getGreen();
                    b0 = colorSet[j - 1].getBlue();
                    r1 = colorSet[j].getRed();
                    g1 = colorSet[j].getGreen();
                    b1 = colorSet[j].getBlue();

                    m = (r1 - r0) / (tempSet[j] - tempSet[j - 1]);
                    b = r1 - m * tempSet[j];
                    rx = Math.min(255, Math.max(0, (int) (m * (val) + b)));

                    m = (g1 - g0) / (tempSet[j] - tempSet[j - 1]);
                    b = g1 - m * tempSet[j];
                    gx = Math.min(255, Math.max(0, (int) (m * (val) + b)));

                    m = (b1 - b0) / (tempSet[j] - tempSet[j - 1]);
                    b = b1 - m * tempSet[j];
                    bx = Math.min(255, Math.max(0, (int) (m * (val) + b)));
                    break;
                }
            }
        }
        Color col = new Color(rx, gx, bx);
        return col;
    }

    /**
     * Open File dialog
     * @param fileExtension
     * @return ClimateFn : file name / path containing climate data to analyse
     */
    public String openDlg(String dlgTitle, String fileExtension) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(dlgTitle);
        chooser.setCurrentDirectory(fileDirectory);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(fileExtension + " files", fileExtension);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            String selectedFile = chooser.getSelectedFile().getPath();
            fileDirectory = chooser.getSelectedFile();
            if (selectedFile != null)
                stationFn = selectedFile;
        }
        System.out.println("selected file = " + stationFn);
        return stationFn;
    }

    /**
     * Save File dialog
     * @param fileExtension
     * @return ClimateFn : file name / path containing climate data to analyse
     */
    public String saveDlg(String dlgTitle, String fileExtension) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(dlgTitle);
        chooser.setSelectedFile(new File("station"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(fileExtension + " files", fileExtension);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(null);
        String selectedFile = null;
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            stationFn = chooser.getSelectedFile().getPath();
        }
        System.out.println("selected file = " + stationFn);
        return stationFn;
    }


    /**
     * Write results file (output.dat) <br>
     * @param OutputFn : file path and name
     */
    public void writeFile(String OutputFn) {
        String txt = appName + "\n";
        txt = txt + "Sname:" + stationName + "\n";
        txt = txt + "Scountry:" + stationCountry + "\n";
        txt = txt + "Slatitude:" + stationLat + "\n";
        txt = txt + "Slongitude:" + stationLon + "\n";
        txt = txt + "Saltitude:" + stationAlt + "\n";
        txt = txt + "Stimezone:" + stationZone + "\n";
        txt = txt + "Sdaylightsave:" + stationDls + "\n";

        if (txt != null) {
            try {
                // create file
                FileWriter outfstream = new FileWriter(OutputFn + ".txt");
                BufferedWriter out = new BufferedWriter(outfstream);

                out.write(txt);
                out.write("\nEOF");

                // close output stream
                out.close();
            } catch (Exception e) // catch exception if any
            {
                JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
                System.err.println("Error: " + e.getMessage());
            }
            System.out.println("donnees disponibles dans " + OutputFn + ".txt");
        }

    }

    /**
     * Read station file <br>
     * @param fileName file path and name
     * @fileFormat fileFormat dat = proprietary format
     */
    public void readFile(String fileName) {
        try {
            // open file
            String inFileName = fileName;
            FileInputStream infstream = new FileInputStream(inFileName);
            DataInputStream in = new DataInputStream(infstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));

            // read proprietary TXT format
            String[] headerList = {
                "Sname", "Scountry", "Slatitude", "Slongitude", "Saltitude", "Stimezone", "Sdaylightsave",
                "Shorizon_az", "Shorizon_ht", "Shorizon_dt"
            };
            double[][] horizonFile = new double[4][100];
            horizonFile[3][1] = 0; // horizon file consistency counter
            String fileSeparator = ":"; // file separator for parsing
            String strLine;
            Collator collator = Collator.getInstance();
            while ((strLine = br.readLine()) != null) {
                String[] fields = strLine.split(fileSeparator, -1); // Convert ';' separated list into Array
                if (collator.compare(fields[0], headerList[0]) == 0)
                    stationName = fields[1];
                else if (collator.compare(fields[0], headerList[1]) == 0)
                    stationCountry = fields[1];
                else if (collator.compare(fields[0], headerList[2]) == 0) {
                    stationLat = fields[1];
                    stationLatVal = Double.parseDouble(fields[1]);
                } else if (collator.compare(fields[0], headerList[3]) == 0) {
                    stationLon = fields[1];
                    stationLonVal = Double.parseDouble(fields[1]);
                } else if (collator.compare(fields[0], headerList[4]) == 0) {
                    stationAlt = fields[1];
                    stationAltVal = Double.parseDouble(fields[1]);
                } else if (collator.compare(fields[0], headerList[5]) == 0) {
                    stationZone = fields[1];
                    stationZoneVal = Double.parseDouble(fields[1]);
                } else if (collator.compare(fields[0], headerList[6]) == 0) {
                    stationDlsVal = Double.parseDouble(fields[1]);
                } else if (collator.compare(fields[0], headerList[7]) == 0) {
                    for (int i = 0; i < fields.length - 1; i++) {
                        horizonFile[0][i] = Double.parseDouble(fields[i + 1]);
                        horizonFile[3][1] = i + 1; // keep track of array size
                    }
                    ++horizonFile[3][0];
                } else if (collator.compare(fields[0], headerList[8]) == 0) {
                    for (int i = 0; i < fields.length - 1; i++) {
                        horizonFile[1][i] = Double.parseDouble(fields[i + 1]);
                    }
                    ++horizonFile[3][0];
                } else if (collator.compare(fields[0], headerList[9]) == 0) {
                    for (int i = 0; i < fields.length - 1; i++) {
                        horizonFile[2][i] = Double.parseDouble(fields[i + 1]);
                    }
                    ++horizonFile[3][0];
                }
            }
            // close input stream
            in.close();

            // calculate horizon angles and load into horizonData
            if (horizonFile[3][0] == 3) // check for consistency of data
                this.horizonData = calcHorizonAngleTable(horizonFile, 0); // horizon ok
            else if (horizonFile[3][0] == 0) {
                String txt =
                    "Information: no horizon section in this file.<br>" +
                    "Obstruction calculations will not be available.";
                JOptionPane.showMessageDialog(null, transformToHTML(txt));
                this.horizonData = calcHorizonAngleTable(horizonFileDummy, 0);
            } else {
                JOptionPane.showMessageDialog(null, "Error: horizon section corrupted");
                this.horizonData = calcHorizonAngleTable(horizonFileDummy, 0);
            }

        } catch (Exception e) // catch exception if any
        {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
            System.err.println("Error: " + e.getMessage());
        }
    }

    /**
     * Transforme le text "message" en html.    *
     * @param message String: Texte  transformer     *
     * @return String: Texte html
     */
    public String transformToHTML(String message) {
        String[] header = new String[2];
        header[0] = "<html><body>";
        header[1] = "</body></html>";
        return header[0] + message + header[1];
    }

    /**
     * Inner class to construct menubar
     */
    class myMenu extends JMenuBar {
        String stringOpenStation = (english) ? "Open station ..." : "Ouvrir lieu ...";
        String stringSaveStation = (english) ? "Save station ..." : "Enregistrer lieu ...";
        String stringSaveOut = (english) ? "Save table ..." : "Enregistrer table ...";
        String stringQuit = (english) ? "Quit" : "Quitter";

        String stringPalette0 = (english) ? "Twilight" : "Crpuscule";
        String stringPalette1 = (english) ? "Twilight discrete" : "Crpuscule discretise";
        String stringPalette2 = (english) ? "Sun altitude" : "Hauteur soleil";
        String stringPalette3 = (english) ? "Sun altitude discrete" : "Hauteur soleil discretise";
        String stringPalette4 = (english) ? "Moon altitude" : "Hauteur lune";
        String stringPalette5 = (english) ? "Moon altitude discrete" : "Hauteur lune discretise";
        String stringPalette6 = (english) ? "Solar energy" : "Energie solaire";
        String stringPalette7 = (english) ? "Energy discrete" : "Energie discretise";
        String stringBanner = (english) ? "Banner only" : "Bannire seule";

        String stringObstruct = (english) ? "Obstructions" : "Obstructions";
        String stringSurfPaz = (english) ? "Azimuth" : "Azimuth";
        String stringSurfInc = (english) ? "Angle" : "Inclinaison";

        String stringSurfInc00 = (english) ? "Horizontal surface" : "Horizontal";
        String stringSurfInc30 = (english) ? "30 tilted surface" : "30 deg";
        String stringSurfInc60 = (english) ? "60 tilted surface" : "60 deg";
        String stringSurfInc90 = (english) ? "Vertical surface" : "Vertical";

        String stringSurfPaz000 = (english) ? "Azimuth 0 North" : "Nord";
        String stringSurfPaz045 = (english) ? "045 N-E" : "N-E";
        String stringSurfPaz090 = (english) ? "090 East" : "Est";
        String stringSurfPaz135 = (english) ? "135 S-E" : "S-E";
        String stringSurfPaz180 = (english) ? "180 South" : "Sud";
        String stringSurfPaz225 = (english) ? "225 S-W" : "S-O";
        String stringSurfPaz270 = (english) ? "270 West" : "Ouest";
        String stringSurfPaz315 = (english) ? "315 N-W" : "N-O";

        String stringYearPrev = (english) ? "Last year" : "Anne passe";
        String stringYearThis = (english) ? "This year" : "Cette anne";
        String stringYearNext = (english) ? "Next year": "Anne suivante";

        String stringAlbedo015 = (english) ? "Default albedo (0.15)" : "Albedo dfaut (0.15)";
        String stringAlbedo085 = (english) ? "Snow (0.85)" : "Neige (0.85)";

        String stringHelp = (english) ? "Help" : "Aide";
        String stringManual = (english) ? "The passive igloo project" : "Le 'passive igloo project'";
        String stringLang = (english) ? "Version franaise" : "English version";
        String stringAbout = (english) ? "About - terms of use" : "A propos conditions d'utilisation";

        public myMenu() {
            JMenu fileMenu = new JMenu((english) ? "File" : "Fichier");
            JMenu optionsMenu = new JMenu((english) ? "Display" : "Affichage");
            JMenu simMenu = new JMenu((english) ? "Calculate" : "Calculer");
            JMenu helpMenu = new JMenu((english) ? "?" : "?");
            JMenu subMenu = new JMenu((english) ? "Solar energy" : "Energie solaire");

            ActionListener menuListener = new ActionListener() {
                public void actionPerformed(ActionEvent event) {
                    String string = event.getActionCommand();
                    System.out.println("Menu item [" + string + "] was selected.");

                    // file menu
                    // ---------
                    if (string.equals(stringOpenStation)) {
                        openDlg(appName + " : open location data", "txt");
                        readFile(stationFn);
                        twilight.this.setTitle(appName + " - " + stationFn + " (txt)");
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSaveStation)) {
                        saveDlg(appName + " : save location data", "txt");
                        writeFile(stationFn);
                        twilight.this.setTitle(appName + " - " + stationFn + " (txt)");
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSaveOut)) {
                        //String outFn = saveDlg(appName + " : save table", "txt") + ".txt";
                        //writeFile(outAnalysis, outFn);
                    } else if (string.equals(stringQuit)) {
                        System.exit(0);
                    }

                    // display menu
                    // ------------
                    else if (string.equals(stringPalette0)) {
                        palette = 0;
                        displayMode = 0;
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringPalette1)) {
                        palette = 1;
                        displayMode = 1;
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringPalette2)) {
                        palette = 2;
                        displayMode = 2;
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringPalette3)) {
                        palette = 3;
                        displayMode = 3;
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringPalette4)) {
                        palette = 4;
                        displayMode = 4;
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringPalette5)) {
                        palette = 5;
                        displayMode = 5;
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringPalette6)) {
                        palette = 6;
                        displayMode = 6;
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringPalette7)) {
                        palette = 7;
                        displayMode = 7;
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringBanner)) {
                        bannerOnly = !bannerOnly;
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    }

                    // simulation menu
                    // ---------------
                    else if (string.equals(stringObstruct)) {
                        int i = 0;
                        for (i = 0; i < horizonData.length; i++) {
                            if (horizonData[i][1] > 0)
                                break;
                        }
                        if (horizonData[1][i] > 0) {
                            obstruct = !obstruct;
                            display.setVisible(false);
                            display.repaint();
                            display.setVisible(true);
                        } else {
                            JOptionPane.showMessageDialog(null, "Information: no horizon data available");
                            obstruct = false;
                            display.setVisible(false);
                            display.repaint();
                            display.setVisible(true);
                        }
                    }
                    // ------
                    else if (string.equals(stringSurfInc00)) {
                        stationIncVal = 0;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSurfInc30)) {
                        stationIncVal = 30;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSurfInc60)) {
                        stationIncVal = 60;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSurfInc90)) {
                        stationIncVal = 90;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                        // -----
                    } else if (string.equals(stringSurfPaz000)) {
                        stationPazVal = 0;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSurfPaz045)) {
                        stationPazVal = 45;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSurfPaz090)) {
                        stationPazVal = 90;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSurfPaz135)) {
                        stationPazVal = 135;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSurfPaz180)) {
                        stationPazVal = 180;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSurfPaz225)) {
                        stationPazVal = 225;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringSurfPaz270)) {
                        stationPazVal = 270;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.repaint();
                    } else if (string.equals(stringSurfPaz315)) {
                        stationPazVal = 315;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringAlbedo015)) {
                        stationAlbedoVal = 0.15;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringAlbedo085)) {
                        stationAlbedoVal = 0.85;
                        if (palette < 6) {
                            palette = 6;
                            displayMode = 6;
                            twilight.this.setJMenuBar(new myMenu());
                        }
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    }
                    // ------
                    else if (string.equals(stringYearPrev)) {
                        stationYearVal--;
                        stationYear = String.format("%.0f", stationYearVal);
                        checkLeapYear();
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringYearThis)) {
                        getThisYear();
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    } else if (string.equals(stringYearNext)) {
                        stationYearVal++;
                        stationYear = String.format("%.0f", stationYearVal);
                        checkLeapYear();
                        display.setVisible(false);
                        display.repaint();
                        display.setVisible(true);
                    }


                    // help menu
                    // ---------
                    else if (string.equals(stringHelp)) {
                        String txt = "Please refer to 'readme.txt' included in the application folder.";
                        JOptionPane.showMessageDialog(null, transformToHTML(txt));
                    } else if (string.equals(stringManual)) {
                        try {
                            String url = (english) ? "http://igloo.sailworks.net" : "http://igloo.sailworks.net";
                            java.awt.Desktop.getDesktop().browse(java.net.URI.create(url));
                        } catch (IOException e) {
                            e.printStackTrace();
                            System.err.println("Error: " + e.getMessage());
                        }
                    } else if (string.equals(stringLang)) {
                        if (english)
                            english = false;
                        else
                            english = true;
                        setJMenuBar(new myMenu());
                        display.repaint();
                    } else if (string.equals(stringAbout)) {
                        String txt =
                            appName + " - version " + appVersion + "<br><br>" +
                            "brought to you by 'the passive igloo project'<br>" + "http://igloo.sailworks.net<br><br>" +
                            "License and warranty:<br>" +
                            appName + " is licenced free of charge. So you are free to use and share it with<br>" +
                            "others provided that copies are not made or distributed for commercial advantage.<br><br>" +
                            "Output from " + appName + " may be published provided that acknowledgement is<br>" +
                            "made to " + appName + " and the copyright holder.<br><br>" +
                            "The program is provided 'as is' and the author does not give warranty of any kind.<br>" +
                            "The entire risk as to the quality, performance and suitability for a particular<br>" +
                            "purpose of the program is with you. In no event, the author will be liable to you<br>" +
                            "for damages or losses including any general, special, incidental or consequential<br>" +
                            "damages raising out of the use or inability to use the program.<br><br>" +
                            "Solar geometry is translated from Greg Pelletier's VBA<br>" + appName +
                            " is Copyright (c) 2016, Peter Gallinelli";
                        JOptionPane.showMessageDialog(null, transformToHTML(txt));
                    }
                }
            };

            JMenuItem item;
            KeyStroke key;
            ButtonGroup buttonGroup;

            // file menu
            // ---------
            item = new JMenuItem(stringOpenStation);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('O'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            /*item = new MenuItem(stringSaveStation);
            MenuShortcut m_save = new MenuShortcut(KeyEvent.getExtendedKeyCodeForChar('S'), false);
            item.setShortcut(m_save);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            item = new MenuItem(stringSaveOut);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            item = new JMenuItem();
            fileMenu.add(item);*/
            item = new JMenuItem(stringQuit);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('Q'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            fileMenu.add(item);

            // display menu
            // ------------
            buttonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(stringPalette0);
            item.setSelected(displayMode == 0);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('1'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringPalette1);
            item.setSelected(displayMode == 1);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('2'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            buttonGroup.add(item);
            optionsMenu.addSeparator();

            item = new JRadioButtonMenuItem(stringPalette2);
            item.setSelected(displayMode == 2);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('3'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringPalette3);
            item.setSelected(displayMode == 3);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('4'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            buttonGroup.add(item);
            optionsMenu.addSeparator();

            item = new JRadioButtonMenuItem(stringPalette4);
            item.setSelected(displayMode == 4);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('5'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringPalette5);
            item.setSelected(displayMode == 5);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('6'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            buttonGroup.add(item);
            optionsMenu.addSeparator();

            item = new JRadioButtonMenuItem(stringPalette6);
            item.setSelected(displayMode == 6);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('7'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringPalette7);
            item.setSelected(displayMode == 7);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('8'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            buttonGroup.add(item);
            optionsMenu.addSeparator();
            
            item = new JRadioButtonMenuItem(stringBanner);
            item.setSelected(bannerOnly);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('B'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            optionsMenu.add(item);

            // simulation menu
            // ---------------
            item = new JMenuItem(stringObstruct);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('0'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            simMenu.add(item);
            simMenu.add(subMenu);

            // simulation submenu
            buttonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(stringSurfInc00);
            item.setSelected(true);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfInc30);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfInc60);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfInc90);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            subMenu.addSeparator();
            // ------
            buttonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(stringSurfPaz000);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfPaz045);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfPaz090);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfPaz135);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfPaz180);
            item.addActionListener(menuListener);
            item.setSelected(true);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfPaz225);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfPaz270);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringSurfPaz315);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            subMenu.addSeparator();
            // ------
            buttonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(stringAlbedo015);
            item.setSelected(true);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);
            item = new JRadioButtonMenuItem(stringAlbedo085);
            item.addActionListener(menuListener);
            subMenu.add(item);
            buttonGroup.add(item);

            simMenu.addSeparator();
            // ------
            item = new JMenuItem(stringYearPrev);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('P'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            simMenu.add(item);
            item = new JMenuItem(stringYearThis);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('T'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            simMenu.add(item);
            item = new JMenuItem(stringYearNext);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('N'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            simMenu.add(item);

            // help menu
            // ---------
            item = new JMenuItem(stringHelp);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar('H'), InputEvent.CTRL_DOWN_MASK, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            helpMenu.add(item);
            item = new JMenuItem(stringManual);
            item.addActionListener(menuListener);
            helpMenu.add(item);
            /*item = new MenuItem(stringLang);
            item.addActionListener(menuListener);
            helpMenu.add(item);*/
            item = new JMenuItem(stringAbout);
            item.addActionListener(menuListener);
            helpMenu.add(item);

            // build menu
            // ----------
            add(fileMenu);
            add(optionsMenu);
            add(simMenu);
            add(helpMenu);
        }
    }


    /**
     * =======================
     *       Main method
     * =======================
     */
    public static void main(String[] args) {
        twilight obj;
        obj = new twilight();
    }
}



// eof